package gov.va.med.mhv.usermgmt.integration.service.delegate;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;

import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.service.ejb.EjbUtil;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.integration.phr.service.ejb.PatientDataServiceRemote;
import gov.va.med.mhv.integration.phr.service.ejb.PatientDataServiceRemoteHome;
import gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus;
import gov.va.med.mhv.integration.phr.transfer.PatientIdentifier;
import gov.va.med.mhv.integration.phr.transfer.RefreshDataParameters;

/**
 * Service delegate for the Patient service
 */
public class PatientDataServiceDelegateImpl
    implements PatientDataServiceDelegate
{

	private static Log log = LogFactory.getLog(
        PatientDataServiceDelegateImpl.class);



	/**
	 * Create a new delegate.
	 */
	public PatientDataServiceDelegateImpl() {
		super();

	}

    /* (non-Javadoc)
     * @see gov.va.med.mhv.usermgmt.integration.service.delegate.
     * PatientDataServiceDelegate#getStatus(
     * gov.va.med.mhv.integration.phr.transfer.PatientIdentifier)
     */
    public PatientExtractStatus getStatus(PatientIdentifier patientID) {
        Precondition.assertNotNull("patientID", patientID);
		PatientDataServiceRemote remote = getRemoteService();
		if (remote == null) {
            throwRemoteUnavailableException();
        }
        try {
            return remote.getStatus(patientID);
		} catch (RemoteException re) {
			String methodName =
                "PatientExtractStatus getStatus(PatientIdentifier patientID)";
			handleRemoteException(methodName, re);
            return null;
		}
	}

    /**
     * Generate a download file, results will be stored in the
     * MHV_DOWNLOAD_REPORT table
     *
     * @param userId   database user id
     * @throws RemoteException
     */
    public void generateDownload(long userId) {
        Precondition.assertPositive("userId", userId);
        PatientDataServiceRemote remote = getRemoteService();
        if (remote == null) {
            throwRemoteUnavailableException();
        }
        try {
            remote.generateDownload(userId);
        } catch (RemoteException re) {
            String methodName =
                "void generateDownload(long userId)";
            handleRemoteException(methodName, re);
        }
    }

    /**
     * Generate a download file, results will be stored in the
     * MHV_DOWNLOAD_REPORT table
     *
     * @param userId   database user id
     * @param options   user selected options
     * @param startDate   user selected start date
     * @param endDate   user selected end date
     * @param dateSelection represents the user selected date range
     * @param typeSelection represents the user selected groups of data
     * @throws RemoteException
     */
	public void generateDownload(long userId, Collection options, Date startDate, Date endDate, long dateSelection, long typeSelection) {
        Precondition.assertPositive("userId", userId);
        PatientDataServiceRemote remote = getRemoteService();
        if (remote == null) {
            throwRemoteUnavailableException();
        }
        try {
        	remote.generateDownload(userId, options, startDate, endDate, dateSelection, typeSelection);
        } catch (RemoteException re) {
            String methodName =
                "void generateDownload(userId, options, startDate, endDate)";
            handleRemoteException(methodName, re);
        }
    }


    /* (non-Javadoc)
     * @see gov.va.med.mhv.usermgmt.integration.service.delegate.
     * PatientDataServiceDelegate#refreshData(
     * gov.va.med.mhv.integration.phr.transfer.RefreshDataParameters)
     */
    public void refreshData(RefreshDataParameters refreshParameters) {
        Precondition.assertNotNull("refreshParameters", refreshParameters);
        PatientDataServiceRemote remote = getRemoteService();
        if (remote == null) {
            throwRemoteUnavailableException();
        }
        try {
            remote.refreshData(refreshParameters);
        } catch (RemoteException re) {
            String methodName =
                "void refreshData(RefreshDataParameters refreshParameters)";
            handleRemoteException(methodName, re);
        }
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.usermgmt.integration.service.delegate.
     * PatientDataServiceDelegate#removePhrData(
     * gov.va.med.mhv.integration.phr.transfer.PatientIdentifier,
     * java.lang.String)
     */
    public void removePhrData(PatientIdentifier patientID,
        String stationNumber)
    {
        Precondition.assertNotNull("patientID", patientID);
        Precondition.assertNotBlank("stationNumber", stationNumber);
        PatientDataServiceRemote remote = getRemoteService();
        if (remote == null) {
            throwRemoteUnavailableException();
        }
        try {
            remote.removePhrData(patientID, stationNumber);
        } catch (RemoteException re) {
            String methodName = "void removePhrData(PatientIdentifier "
                + "patientID, String stationNumber)";
            handleRemoteException(methodName, re);
        }
    }

	/**
	 * Gets the remote stub for a session bean call
	 * @return The <tt>PatientDataServiceRemote</tt> to use to perform
     * a remote call
	 */
	protected PatientDataServiceRemote getRemoteService() {
		PatientDataServiceRemote remote = null;
		Context ic = null;
		Object o = null;
		try {
			ic = new InitialContext();
			o = PortableRemoteObject.narrow(ic.lookup(
                PatientDataServiceRemoteHome.JNDI_NAME),
				PatientDataServiceRemoteHome.class);
			PatientDataServiceRemoteHome home = (PatientDataServiceRemoteHome)o;
			remote = home.create();
		} catch (ClassCastException cce) {
			if (log.isErrorEnabled()) {
				log.error("A class cast exception occurred looking up service \"PatientDataService\"'s remote stub." +
					" Expected \"PatientDataService\", but returned \"" + o.getClass() + "\"", cce);
			}

		} catch (RemoteException re) {
			if (log.isErrorEnabled()) {
				log.error("A remote exception occurred looking up service \"PatientDataService\"'s remote stub", re);
			}
		} catch (NamingException ne) {
			if (log.isErrorEnabled()) {
				log.error("A naming exception occurred looking up service \"PatientDataService\"'s remote stub", ne);
			}

		} catch (CreateException ce) {
			if (log.isErrorEnabled()) {
				log.error("A creation exception occurred looking up service \"PatientDataService\"'s remote stub", ce);
			}

		} finally {
			EjbUtil.closeContext(ic);

		}

		return remote;
	}

	private void handleRemoteException(String methodName,
        RemoteException re)
    {
		if (log.isErrorEnabled()) {
			log.error("Exception occurred during " + methodName, re);

		}
        throw new RuntimeException(re);
	}

	private void throwRemoteUnavailableException()  {
        String message = "\"PatientDataServiceRemote\" is unavailable!";
		if (log.isErrorEnabled()) {
			log.error(message);

		}
        throw new RuntimeException(message);
	}


}